/***************************************************************************** 
                                                  COPYRIGHT (c) Freescale 2005   
                                                                             
File Name          :    $RCSfile: S12XATD12B16CV1.h,v $                    
                                                                             
Current Revision :      $Revision: 1.0 $                                   
                                                                             
PURPOSE: header file for HCS12XE 16-channel 12-bit ATD block             
                                                                             
                                                                             
DESCRIPTION: Defines the 16-channel ATD block as a datastructure of        
             type tATD16.                                                  
                                                                             
NOTES: register types have an _16 posfix to allow definition of registers  
       on devices having both 16 channel and other channel size ATD        
       modules,                                                            
                                                                            
UPDATE HISTORY                                                             
REV  AUTHOR       DATE       DESCRIPTION OF CHANGE                         
---  ------      --------    ---------------------                         
1.0  r32151      31/08/05    - Initial coding based on S12ATD10B16CV4.h 
1.1  r32151      14/04/06    - moved DJM bit from ctl5 regi to ctl3 reg. 


      *****************************************************************
      *File created by: Freescale East Kilbride MCD Applications Group*
      *****************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12XATD12B16CV1_H   /*prevent duplicated includes */
#define S12XATD12B16CV1_H

#include "S12_COMMON.h"

typedef union uATDCTL0_16
{
   tU08 byte;
   struct
    {
      tU08 wrap    :4;     /*wrap around ch. select bits */
      tU08         :4;     /*not used */
    }bit;
}tATDCTL0_16;

/*bit masks for ATDCTL0 */
#define WRAP0  0x01  
#define WRAP1  0x02
#define WRAP2  0x04
#define WRAP3  0x08

typedef union uATDCTL1_16
{
   tU08 byte;
   struct
    {
      tU08 etrigch :4;     /*external trigger channel select */
      tU08 smpdis  :1;     /*sample discharge */
      tU08 sres    :2;     /*conversion resolution */
                                 /* 0:0 = 8-bit    */
                                 /* 0:1 = 10-bit   */
                                 /* 1:0 = 12-bit   */
                                 /* 1:1 = reserved */
      tU08 etrigsel:1;     /*external trigger source select */
    }bit;
}tATDCTL1_16;

/*bit masks for ATDCTL1 */
#define ETRIGCH0  0x01  
#define ETRIGCH1  0x02
#define ETRIGCH2  0x04
#define ETRIGCH3  0x08
#define SMPDIS    0x10
#define SRES0     0x20
#define SRES1     0x40
#define ETRIGSEL  0x80

#define RES8   0x00
#define RES10  SRES0
#define RES12  SRES1

typedef union uATDCTL2_16
{
   tU08 byte;
   struct
    {
      tU08 acmpie  :1;     /*atd compare interrupt enable */
      tU08 ascie   :1;     /*atd complete interrupt enable */
      tU08 etrige  :1;     /*external trigger mode enable */
      tU08 etrigp  :1;     /*external trigger polarity */
      tU08 etrigle :1;     /*external trigger level/edge control */
      tU08 iclkstp :1;     /*atd internal clock in stop mode */
      tU08 affc    :1;     /*atd fast flag clear all */
      tU08         :1;     /*not used */
    }bit;
}tATDCTL2_16;

/*bit masks for ATDCTL2 */
#define ACMPIE    0x01  
#define ASCIE     0x02
#define ETRIGE    0x04
#define ETRIGP    0x08
#define ETRIGLE   0x10
#define ICLKSTP   0x20
#define AFFC      0x40

typedef union uATDCTL3_16
{
   tU08 byte;
   struct
    {
      tU08 frz  :2;      /*atd background mode */
      tU08 fifo :1;      /*results mapped to fifo mode */
      tU08 slc  :4;      /*conversion sequence length */
      tU08 djm  :1;      /*result data register justification mode */
    }bit;
}tATDCTL3_16;

/*bit masks for ATDCTL3 */
#define FRZ0   0x01  
#define FRZ1   0x02
#define FIFO   0x04
#define S1C    0x08
#define S2C    0x10
#define S4C    0x20
#define S8C    0x40
#define DJM    0x80

typedef union uATDCTL4_16
{
   tU08 byte;
   struct
    {
      tU08 prs :5;      /*atd P clock prescaler */
      tU08 smp :3;      /*atd sample time */
    }bit;
}tATDCTL4_16;

/*bit masks for ATDCTL4 */
#define PRS0   0x01  
#define PRS1   0x02
#define PRS2   0x04
#define PRS3   0x08
#define PRS4   0x10
#define SMP0   0x20
#define SMP1   0x40
#define SMP2   0x80

typedef union uATDCTL5_16
{
   tU08 byte;
    struct
    {
      tU08 cx     :4;      /*atd channel select */
      tU08 mult   :1;      /*atd multichannel conversion enable */
      tU08 scan   :1;      /*atd continuous scan enable */
      tU08 sc     :1;      /*special channel conversion mode */
      tU08        :1;      /*not used */
    }bit;
}tATDCTL5_16;

/*bit masks for ATDCTL5 */
#define CA     0x01  
#define CB     0x02
#define CC     0x04
#define CD     0x08
#define MULT   0x10
#define SCAN   0x20
#define SC     0x40

typedef union uATDSTAT0_16
{
   tU08 byte;
   struct
    {
      tU08 ccx    :4;      /*conversion counter for current sequence */
      tU08 fifor  :1;      /*fifo overrun flag */
      tU08 etorf  :1;      /*external trigger overrun flag */
      tU08        :1;      /*not used */
      tU08 scf    :1;      /*atd sequence complete flag */
    }bit;
}tATDSTAT0_16;

/*bit masks for ATDSTAT0 */
#define CC0    0x01  
#define CC1    0x02
#define CC2    0x04
#define CC3    0x08
#define FIFOR  0x10
#define ETORF  0x20
#define SCF    0x80


/* several word sized registers from this point are defined on a byte   */
/* register basis to be easily compatible with 8 channel modules.       */
/* This relects the device user guide register map but not the block    */
/* block user guide definitions.                                        */
/* This also works with the default setting for the Metrowerks compiler */
/* and existing header files. In order to use 16-bit register bit       */
/* fields the compiler would have to be configured for Bitfield Most    */
/* Significant Bit first and the bitfield definitions in all header     */
/* files reversed. */

typedef union uATDCMPEH_16
{
   tU08 byte;
   struct
    {
      tU08 cmpe8       :1;      /*channel compare enables */
      tU08 cmpe9       :1;      
      tU08 cmpe10      :1;      
      tU08 cmpe11      :1;      
      tU08 cmpe12      :1;      
      tU08 cmpe13      :1;      
      tU08 cmpe14      :1;      
      tU08 cmpe15      :1;      
    }bit;
}tATDCMPEH_16;

/*bit masks for ATDCMPH */
#define CMPE8  BIT0
#define CMPE9  BIT1
#define CMPE10 BIT2
#define CMPE11 BIT3
#define CMPE12 BIT4
#define CMPE13 BIT5
#define CMPE14 BIT6
#define CMPE15 BIT7


typedef union uATDCMPEL_16
{
   tU08 byte;
   struct
    {
      tU08 cmpe0       :1;      /*channel compare enables */
      tU08 cmpe1       :1;      
      tU08 cmpe2       :1;      
      tU08 cmpe3       :1;      
      tU08 cmpe4       :1;      
      tU08 cmpe5       :1;      
      tU08 cmpe6       :1;      
      tU08 cmpe7       :1;      
    }bit;
}tATDCMPEL_16;

/*bit masks for ATDCMPL */
#define CMPE0  BIT0  
#define CMPE1  BIT1
#define CMPE2  BIT2
#define CMPE3  BIT3
#define CMPE4  BIT4
#define CMPE5  BIT5
#define CMPE6  BIT6
#define CMPE7  BIT7

typedef union uATDSTAT2_16
{
   tU08 byte;
   struct
    {
      tU08 ccf8   :1;      /*atd conversion complete flags */
      tU08 ccf9   :1;
      tU08 ccf10  :1;
      tU08 ccf11  :1;
      tU08 ccf12  :1;
      tU08 ccf13  :1;
      tU08 ccf14  :1;
      tU08 ccf15  :1;
    }bit;
}tATDSTAT2_16;

/*bit masks for ATDSTAT2 */
#define CCF8   0x01  
#define CCF9   0x02
#define CCF10  0x04
#define CCF11  0x08
#define CCF12  0x10
#define CCF13  0x20
#define CCF14  0x40
#define CCF15  0x80

typedef union uATDSTAT1_16
{
   tU08 byte;
   struct
    {
      tU08 ccf0   :1;      /*atd conversion complete flags */
      tU08 ccf1   :1;
      tU08 ccf2   :1;
      tU08 ccf3   :1;
      tU08 ccf4   :1;
      tU08 ccf5   :1;
      tU08 ccf6   :1;
      tU08 ccf7   :1;
    }bit;
}tATDSTAT1_16;

/*bit masks for ATDSTAT1 */
#define CCF0   0x01  
#define CCF1   0x02
#define CCF2   0x04
#define CCF3   0x08
#define CCF4   0x10
#define CCF5   0x20
#define CCF6   0x40
#define CCF7   0x80


typedef union uATDDIEN0_16
{
   tU08 byte;
   struct
    {
      tU08 ien0   :1;      /*input enable mask */
      tU08 ien1   :1;
      tU08 ien2   :1;
      tU08 ien3   :1;
      tU08 ien4   :1;
      tU08 ien5   :1;
      tU08 ien6   :1;
      tU08 ien7   :1;
    }bit;
}tATDDIEN0_16;

/*bit masks for ATDDIEN0 */
#define IEN0   0x01  
#define IEN1   0x02
#define IEN2   0x04
#define IEN3   0x08
#define IEN4   0x10
#define IEN5   0x20
#define IEN6   0x40
#define IEN7   0x80

typedef union uATDDIEN1_16
{
   tU08 byte;
   struct
    {
      tU08 ien8   :1;      /*input enable mask */
      tU08 ien9   :1;
      tU08 ien10  :1;
      tU08 ien11  :1;
      tU08 ien12  :1;
      tU08 ien13  :1;
      tU08 ien14  :1;
      tU08 ien15  :1;
    }bit;
}tATDDIEN1_16;

/*bit masks for ATDDIEN1 */
#define IEN8   0x01  
#define IEN9   0x02
#define IEN10  0x04
#define IEN11  0x08
#define IEN12  0x10
#define IEN13  0x20
#define IEN14  0x40
#define IEN15  0x80

typedef union uATDCMPHTH_16
{
   tU08 byte;
   struct
    {
      tU08 cmpht8  :1;      /*compare higher than enables */
      tU08 cmpht9  :1;
      tU08 cmpht10 :1;
      tU08 cmpht11 :1;
      tU08 cmpht12 :1;
      tU08 cmpht13 :1;
      tU08 cmpht14 :1;
      tU08 cmpht15 :1;
    }bit;
}tATDCMPHTH_16;

/*bit masks for ATDCMPHTH */
#define CMPHT8     0x01  
#define CMPHT9     0x02
#define CMPHT10    0x04
#define CMPHT11    0x08
#define CMPHT12    0x10
#define CMPHT13    0x20
#define CMPHT14    0x40
#define CMPHT15    0x80

typedef union uATDCMPHTL_16
{
   tU08 byte;
   struct
    {
      tU08 cmpht0  :1;      /*compare higher than enables */
      tU08 cmpht1  :1;
      tU08 cmpht2  :1;
      tU08 cmpht3  :1;
      tU08 cmpht4  :1;
      tU08 cmpht5  :1;
      tU08 cmpht6  :1;
      tU08 cmpht7  :1;
    }bit;
}tATDCMPHTL_16;

/*bit masks for PORTAD1 */
#define CMPHT0   0x01  
#define CMPHT1   0x02
#define CMPHT2   0x04
#define CMPHT3   0x08
#define CMPHT4   0x10
#define CMPHT5   0x20
#define CMPHT6   0x40
#define CMPHT7   0x80
  
typedef union uATDDR_16    /*ATD data register */
{
   tU16 word;        
   struct            
    {
      tU08 datah;       
      tU08 datal;       
    }byte;
}tATDDR_16;

typedef struct                      /*atd module */ 
{
  volatile tATDCTL0_16     atdctl0;    /*atd control register 0 */
  volatile tATDCTL1_16     atdctl1;    /*atd control register 1 */
  volatile tATDCTL2_16     atdctl2;    /*atd control register 2 */
  volatile tATDCTL3_16     atdctl3;    /*atd control register 3 */
  volatile tATDCTL4_16     atdctl4;    /*atd control register 4 */
  volatile tATDCTL5_16     atdctl5;    /*atd control register 5 */
  volatile tATDSTAT0_16    atdstat0;   /*atd status register 0 */
           tU08            rsv1;       /*reserved (maintaining memory map) */  
  volatile tATDCMPEH_16    atdcmpeh;   /*enable compare register */
  volatile tATDCMPEL_16    atdcmpel;   /*enable compare register */
  volatile tATDSTAT2_16    atdstat2;   /*atd status register 2 */
  volatile tATDSTAT1_16    atdstat1;   /*atd status register 1 */
  volatile tATDDIEN0_16    atddien0;   /*atd digital buffer enable */
  volatile tATDDIEN1_16    atddien1;   /*atd digital buffer enable */
  volatile tATDCMPHTH_16   atdcmphth;  /*enable compare higher than register */
  volatile tATDCMPHTL_16   atdcmphtl;  /*enable compare higher than register */
  volatile tATDDR_16       atddr[16];  /*atd result registers*/
}tATD16;

#endif /*S12XATD12B16CV1_H*/